<?php
/* -----------------------------------------------------------------------------------------
   $Id$

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   -----------------------------------------------------------------------------------------
   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

defined( '_VALID_XTC' ) or die( 'Direct Access to this location is not allowed.' );

// include needed functions
// ATTENTION: file MUST have same name as class! Otherwise it will not be loaded. (classname.php)
class dummy_module {
  var $code, $title, $description, $enabled, $sort_order;

	function __construct() {
		$this->code = 'dummy_module';
		$this->title = 'Dummy'; //MODULE_DUMMY_MODULE_TEXT_TITLE;
		$this->description = 'Dummy long'; //MODULE_DUMMY_MODULE_TEXT_LONG_DESCRIPTION;
		$this->sort_order = defined('MODULE_DUMMY_MODULE_SORT_ORDER') ? MODULE_DUMMY_MODULE_SORT_ORDER : 0;
		$this->enabled = ((MODULE_DUMMY_MODULE_STATUS == 'true') ? true : false);
	}

	function process($file) {
		if (isset($_POST['configuration']) && $_POST['configuration']['MODULE_DUMMY_MODULE_STATUS'] == 'true') {
			xtc_redirect(xtc_href_link('dummy_module.php'));
		}
	}

	function display() {
		return array('text' => '<br /><div align="center">' . xtc_button(BUTTON_SAVE) .
			xtc_button_link(BUTTON_CANCEL, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=dummy_module')) . "</div>");
	}

	function check() {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("SELECT configuration_value 
                                     FROM " . TABLE_CONFIGURATION . "
                                    WHERE configuration_key = 'MODULE_DUMMY_MODULE_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}

	function install() {
		xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) 
				VALUES ('MODULE_DUMMY_MODULE_STATUS', 'false',  '6', '1', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");  
		xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) 
				VALUES ('MODULE_DUMMY_MODULE_DELETE_DATA_ON_UNINSTALL', 'false',  '6', '1', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");  
		trigger_error("Updated table configuration set dummy_module by " . $_SESSION['customer_id'], E_USER_NOTICE);
		// Create Tabel only if not exists
		xtc_db_query("CREATE TABLE IF NOT EXISTS `dummy_module`(
                  `id` INT(11) NOT NULL,
                  `datacolumn1` VARCHAR(15) DEFAULT NULL,
                  `datacolumn2` VARCHAR(32) NOT NULL,
                  `datacolumn3` INT(1) NOT NULL,
                  `datadate` DATETIME NOT NULL,
                  `date_added` DATETIME NOT NULL
                ) ENGINE=MYISAM" );
		trigger_error("Created table dummy_module by " . $_SESSION['customer_id'], E_USER_NOTICE);
		xtc_db_query("ALTER TABLE `dummy_module` ADD PRIMARY KEY(`id`)");
		xtc_db_query("ALTER TABLE `dummy_module` MODIFY `id` INT(11) NOT NULL AUTO_INCREMENT; )");
		trigger_error("Added keys to table dummy_module by " . $_SESSION['customer_id'], E_USER_NOTICE);
		xtc_db_query("ALTER TABLE `admin_access` ADD `dummy_module` INT(1) NOT NULL DEFAULT '1'");
		trigger_error("Added column dummy_module to table configuration by " . $_SESSION['customer_id'], E_USER_NOTICE);
		
		// Only load files from autoinclude-directories if install of database-tables was successful
		// autoinclude-files are not loaded if fileextensiuon is not php
		// just rename files
		try{	
			// Files in shoproot/includes/extra/...
			rename(DIR_FS_CATALOG.'includes/extra/header/header_body/' . 'dummy_module.php_deact', DIR_FS_CATALOG.'includes/extra/header/header_body/' . 'dummy_module.php');
			// Files in shoproot/YOUR_ADMIN_DIRECTORY/includes/extra/...
			rename(DIR_ADMIN.'includes/extra/applictaion_bottom/' . 'dummy_module.php_deact', DIR_ADMIN.'includes/extra/applictaion_bottom/' . 'dummy_module.php');
		}
		catch(Exception $e){
			trigger_error("Install of module dummy failed: ".$e->getMessage(), E_USER_ERROR);
		}
	}

	function remove() {
		xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_DUMMY_MODULE_STATUS'");
		trigger_error("Deleted congiguration_key MODULE_DUMMY_MODULE_STATUS by " . $_SESSION['customer_id'], E_USER_NOTICE);
		// Delete only if MODULE_DUMMY_MODULE_DELETE_DATA_ON_UNINSTALL is set true, standard is false
		if (MODULE_DUMMY_MODULE_DELETE_DATA_ON_UNINSTALL == true){
			xtc_db_query("DROP TABLE dummy_module");
			trigger_error("Dropped table dummy_module by " . $_SESSION['customer_id'], E_USER_NOTICE);
			xtc_db_query("ALTER TABLE `admin_access` DROP `dummy_module`;");
			trigger_error("Deleted column dummy_module from table admin_access by " . $_SESSION['customer_id'], E_USER_NOTICE);
		}
		xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_DUMMY_MODULE_DELETE_DATA_ON_UNINSTALL'");
		
		// Only load files from autoinclude-directories if install of database-tables was successful
		// autoinclude-files are not loaded if fileextensiuon is not php
		// just rename files
		try{	
			// Files in shoproot/includes/extra/...
		rename(DIR_FS_CATALOG.'includes/extra/header/header_body/' . 'dummy_module.php', DIR_FS_CATALOG.'includes/extra/header/header_body/' . 'dummy_module.php_deact');
			// Files in shoproot/YOUR_ADMIN_DIRECTORY/includes/extra/...
		rename(DIR_ADMIN.'includes/extra/applictaion_bottom/' . 'dummy_module.php', DIR_ADMIN.'includes/extra/applictaion_bottom/' . 'dummy_module.php_deact');
		}
		catch(Exception $e){
			trigger_error("Install of module dummy failed: ".$e->getMessage(), E_USER_ERROR);
		}

	}

	function keys() {
		$key = array('MODULE_DUMMY_MODULE_STATUS', 
					'MODULE_DUMMY_MODULE_DELETE_DATA_ON_UNINSTALL');

		return $key;
	}
}
?>