<?php
/* -----------------------------------------------------------------------------------------
   $Id: general.css.php 4200 2013-01-10 19:47:11Z Tomcraft1980 $

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2006 XT-Commerce

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

$css_foundation_plain = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/css/foundation.css';
$css_foundation_min = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/css/foundation.min.css';
$css_app_plain = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/css/app.css';
$css_app_min = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/css/app.min.css';


function compress_stylesheet($css_plain, $css_min, $css_filename = 'stylesheet.css', $css_filename_min = 'stylesheet.min.css'){
	// function should be moved to /includes/somefilename.php
	require_once(DIR_FS_EXTERNAL.'compactor/compactor.php');
	
	$css_file = $css_filename;

	if (($css_content = file_get_contents($css_plain)) !== false) {
		$compactor = new Compactor(array('strip_php_comments' => true));
		$css_content = $compactor->squeeze($css_content);
		try {
			if (file_put_contents($css_min, $css_content, LOCK_EX) !== false) {
				$css_file = $css_filename_min;
			}
		} catch (Exception $e) {
			trigger_error('func compress_stylesheet', $e->getMessage());
		}
	}
	return $css_file;
	
}

function auto_compress_stylesheet($css_plain, $css_min, $css_filename = 'stylesheet.css', $css_filename_min = 'stylesheet.min.css'){

	$css_file = $css_filename;

	if (COMPRESS_STYLESHEET == 'true') {
		//require_once(DIR_FS_EXTERNAL.'compactor/compactor.php');
		if (file_exists($css_min)){
			if (filemtime($css_plain) > filemtime($css_min)) {
				compress_stylesheet($css_plain, $css_min, $css_filename, $css_filename_min);
			} else {
			//stylesheet.css is older than stylesheet.min.css => nothing to do
				$css_file = $css_filename_min;
			}
		} else{
			// stylesheet.min.css does not exist => create
			compress_stylesheet($css_plain, $css_min, $css_filename, $css_filename_min);
		}
	}

	return $css_file;

}


$css_foundation_file = auto_compress_stylesheet($css_foundation_plain,$css_foundation_min, 'foundation.css','foundation.min.css');
$css_app_file = auto_compress_stylesheet($css_app_plain,$css_app_min, 'app.css', 'app.min.css');


  // Put CSS-Inline-Definitions here, these CSS-files will be loaded at the TOP of every page
?>
<link rel="stylesheet" href="<?php echo DIR_WS_BASE.'templates/'.CURRENT_TEMPLATE.'/css/'.$css_foundation_file; ?>" type="text/css" media="screen" />
<link rel="stylesheet" href="<?php echo DIR_WS_BASE.'templates/'.CURRENT_TEMPLATE.'/css/'.$css_app_file; ?>" type="text/css" media="screen" />
