<?php
// includes/modules/payment/banktransfer.php ==========================================================================

function javascript_validation() {
      $js = 'if (payment_value == "' . $this->code . '") {' . "\n" .
            '  var banktransfer_bic = document.getElementById("checkout_payment").banktransfer_bic.value;' . "\n" .
            '  var banktransfer_iban = document.getElementById("checkout_payment").banktransfer_iban.value;' . "\n" .
            '  var banktransfer_blz = document.getElementById("checkout_payment").banktransfer_blz.value;' . "\n" .
            '  var banktransfer_number = document.getElementById("checkout_payment").banktransfer_number.value;' . "\n" .
            '  var banktransfer_owner = document.getElementById("checkout_payment").banktransfer_owner.value;' . "\n" .
            '  if (document.getElementById("checkout_payment").banktransfer_fax) { ' . "\n" .
            '    var banktransfer_fax = document.getElementById("checkout_payment").banktransfer_fax.checked;' . "\n" .
            '  } else { var banktransfer_fax = false; } ' . "\n" .            
            '  if (banktransfer_fax == false) {' . "\n" . 
            '    if (banktransfer_bic != "" || banktransfer_iban != "") {' . "\n" .
            '      if (banktransfer_bic == "") {' . "\n" .
            '        error_message = error_message + "' . JS_BANK_BIC . '";' . "\n" .
            '        error = 1;' . "\n" .
            '      }' . "\n" .
            '      if (banktransfer_iban == "") {' . "\n" .
            '        error_message = error_message + "' . JS_BANK_IBAN . '";' . "\n" .
            '        error = 1;' . "\n" .
            '      }' . "\n" .
            '    }' . "\n" .
            '    else {' . "\n" .
            '      if (banktransfer_blz == "") {' . "\n" .
            '        error_message = error_message + "' . JS_BANK_BLZ . '";' . "\n" .
            '        error = 1;' . "\n" .
            '      }' . "\n" .
            '      if (banktransfer_number == "") {' . "\n" .
            '        error_message = error_message + "' . JS_BANK_NUMBER . '";' . "\n" .
            '        error = 1;' . "\n" .
            '      }' . "\n" .
            '    }' . "\n" .          
            '    if (banktransfer_owner == "") {' . "\n" .
            '      error_message = error_message + "' . JS_BANK_OWNER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '  }' . "\n" .
            '}' . "\n";
      return $js;
    }

function selection() {
      global $order;

// banktransfer_number von size 20 auf 40, da die iban mit füllzeichen so lang werden kann (ohne die max 34), 11.10.2013 vr
      $selection = array('id' => $this->code,
                         'module' => $this->title,
                         'description'=>$this->info,
      	                 'fields' => array(array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE,
      	                                         'field' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_INFO),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_OWNER,
      	                                         'field' => xtc_draw_input_field('banktransfer_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'], 'size="40"')),
                                           array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_BIC,
      	                                         'field' => xtc_draw_input_field('banktransfer_bic', $_GET['banktransfer_bic'], 'size="40" maxlength="11"')),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_IBAN,
      	                                         'field' => xtc_draw_input_field('banktransfer_iban',  $_GET['banktransfer_iban'], 'size="40" maxlength="50"')),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_BLZ,
      	                                         'field' => xtc_draw_input_field('banktransfer_blz', $_GET['banktransfer_blz'], 'size="40" maxlength="8"')),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_NUMBER,
      	                                         'field' => xtc_draw_input_field('banktransfer_number',  $_GET['banktransfer_number'], 'size="40" maxlength="32"')),
      	                                   array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_NAME,
      	                                         'field' => xtc_draw_input_field('banktransfer_bankname')),
      	                                   array('title' => '',
      	                                         'field' => xtc_draw_hidden_field('recheckok', $_POST['recheckok']))
      	                                   ));

      if (MODULE_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION =='true'){
        $selection['fields'][] = array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE,
      	                               'field' => MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE2 . '<a href="' . MODULE_PAYMENT_BANKTRANSFER_URL_NOTE . '" target="_blank"><b>' . MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE3 . '</b></a>' . MODULE_PAYMENT_BANKTRANSFER_TEXT_NOTE4);
      	$selection['fields'][] = array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_FAX,
      	                               'field' => xtc_draw_checkbox_field('banktransfer_fax', 'on'));

      }

      return $selection;
    }



function pre_confirmation_check(){

      if ($_POST['banktransfer_fax'] == false  && $_POST['recheckok'] != 'true') {
        include(DIR_WS_CLASSES . 'banktransfer_validation.php');
        include(DIR_WS_EXTERNAL . 'php-iban/php-iban.php');
        
        // check iban and bic
        if (!empty($_POST['banktransfer_iban']) || !empty($_POST['banktransfer_bic'])) {
          // bic o.k.?
          if (empty($_POST['banktransfer_bic'])) {
            $banktransfer_result = 11; // no bic
          }  
          // iban o.k.?
          else if (verify_iban($_POST['banktransfer_iban'])) {
            $banktransfer_iban_parts = iban_get_parts($_POST['banktransfer_iban']);
            // normalize iban
            $_POST['banktransfer_iban'] = iban_to_machine_format($_POST['banktransfer_iban']);
            $banktransfer_result = 0; // o.k.
          }
          else {
            $banktransfer_result = 12; // not o.k.
          }
        }

        $banktransfer_validation = new AccountCheck;
        if (empty($banktransfer_result)) {
          if (empty($banktransfer_iban_parts)) {
            $banktransfer_result = $banktransfer_validation->CheckAccount($_POST['banktransfer_number'], $_POST['banktransfer_blz']);
          }
          else if ($banktransfer_iban_parts['country'] == 'DE') {
            // take blz and number from iban, if iban was given and is o.k.
            $_POST['banktransfer_blz'] = $banktransfer_iban_parts['bank'];
            $_POST['banktransfer_number'] = $banktransfer_iban_parts['account'];
            $banktransfer_result = $banktransfer_validation->CheckAccount($_POST['banktransfer_number'], $_POST['banktransfer_blz']);
          }
        }

		    if ($banktransfer_validation->Bankname != '') {
          $this->banktransfer_bankname = $banktransfer_validation->Bankname;
        } else {
          $this->banktransfer_bankname = xtc_db_prepare_input($_POST['banktransfer_bankname']);
        }

        if ($_POST['banktransfer_owner'] == '') {
          $banktransfer_result = 10;
        }
 
        switch ($banktransfer_result) {
          case 0: // payment o.k.
                  $error = 'O.K.';
                  $recheckok = 'false';
                  break;
          case 1: // number & blz not ok
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_1;
                  $recheckok = 'false';
                  break;
          case 2: // account number has no calculation method
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_2;
                  $recheckok = 'true';
                  break;
          case 3: // No calculation method implemented
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_3;
                  $recheckok = 'true';
                  break;
          case 4: // Number cannot be checked
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_4;
                  $recheckok = 'true';
                  break;
          case 5: // BLZ not found
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_5;
                  $recheckok = 'false'; // Set "true" if you have not the latest BLZ table!
                  break;
          case 8: // no BLZ entered
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_8;
                  $recheckok = 'false';
                  break;
          case 9: // no number entered
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_9;
                  $recheckok = 'false';
                  break;
          case 10: // no account holder entered
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_10;
                  $recheckok = 'false';
                  break;
          case 11: // no bic entered
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_11;
                  $recheckok = 'false';
                  break;
          case 12: // iban not o.k.
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_12;
                  $recheckok = 'false';
                  break;
          case 128: // Internal error
                  $error = 'Internal error, please check again to process your payment';
                  $recheckok = 'true';
                  break;
          default:
                  $error = MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_4;
                  $recheckok = 'true';
                  break;
        }  

        if ($banktransfer_result > 0 && $_POST['recheckok'] != 'true') {
          $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&banktransfer_owner=' . urlencode($_POST['banktransfer_owner']) . '&banktransfer_bic=' . urlencode($_POST['banktransfer_bic']) . '&banktransfer_iban=' . urlencode($_POST['banktransfer_iban']) . '&banktransfer_number=' . urlencode($_POST['banktransfer_number']) . '&banktransfer_blz=' . urlencode($_POST['banktransfer_blz']) . '&banktransfer_bankname=' . urlencode($_POST['banktransfer_bankname']) . '&recheckok=' . $recheckok;
          xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
        }
        
     	  $this->banktransfer_owner = xtc_db_prepare_input($_POST['banktransfer_owner']);
        $this->banktransfer_bic = xtc_db_prepare_input($_POST['banktransfer_bic']);
        $this->banktransfer_iban = xtc_db_prepare_input($_POST['banktransfer_iban']);
        $this->banktransfer_blz = xtc_db_prepare_input($_POST['banktransfer_blz']);
        $this->banktransfer_number = xtc_db_prepare_input($_POST['banktransfer_number']);
        $this->banktransfer_prz = $banktransfer_validation->PRZ;
        $this->banktransfer_status = $banktransfer_result;
      }
    }

    function confirmation() {
      global $banktransfer_val, $banktransfer_owner, $banktransfer_bankname, $banktransfer_bic, $banktransfer_iban, $banktransfer_blz, $banktransfer_number, $checkout_form_action, $checkout_form_submit;

      if (!$_POST['banktransfer_owner'] == '') {
        $confirmation = array('title' => $this->title,
                              'fields' => array(array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_OWNER,
                                                      'field' => $this->banktransfer_owner),
                                                array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_BIC,
                                                      'field' => $this->banktransfer_bic),
                                                array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_IBAN,
                                                      'field' => $this->banktransfer_iban),
                                                array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_BLZ,
                                                      'field' => $this->banktransfer_blz),
                                                array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_NUMBER,
                                                      'field' => $this->banktransfer_number),
                                                array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_NAME,
                                                      'field' => $this->banktransfer_bankname)
                                                ));
      }
      if ($_POST['banktransfer_fax'] == "on") {
        $confirmation = array('fields' => array(array('title' => MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_FAX)));
        $this->banktransfer_fax = "on";
      }
      return $confirmation;
    }

function process_button() {
      global $_POST;

      $process_button_string = xtc_draw_hidden_field('banktransfer_blz', $this->banktransfer_blz) .
                               xtc_draw_hidden_field('banktransfer_bankname', $this->banktransfer_bankname).
                               xtc_draw_hidden_field('banktransfer_bic', $this->banktransfer_bic) .
                               xtc_draw_hidden_field('banktransfer_iban', $this->banktransfer_iban) .
                               xtc_draw_hidden_field('banktransfer_number', $this->banktransfer_number) .
                               xtc_draw_hidden_field('banktransfer_owner', $this->banktransfer_owner) .
                               xtc_draw_hidden_field('banktransfer_status', $this->banktransfer_status) .
                               xtc_draw_hidden_field('banktransfer_prz', $this->banktransfer_prz) .
                               xtc_draw_hidden_field('banktransfer_fax', $this->banktransfer_fax);

      return $process_button_string;

    }

function after_process() {
      global $insert_id, $_POST, $banktransfer_val, $banktransfer_owner, $banktransfer_bankname, $banktransfer_bic, $banktransfer_iban, $banktransfer_blz, $banktransfer_number, $banktransfer_status, $banktransfer_prz, $banktransfer_fax, $checkout_form_action, $checkout_form_submit;
      xtc_db_query("INSERT INTO banktransfer (orders_id, banktransfer_blz, banktransfer_bankname, banktransfer_number, banktransfer_owner, banktransfer_status, banktransfer_prz, banktransfer_bic, banktransfer_iban) VALUES ('" . $insert_id . "', '" . $this->banktransfer_blz . "', '" . $this->banktransfer_bankname . "', '" . $this->banktransfer_number . "', '" . $this->banktransfer_owner ."', '" . $this->banktransfer_status ."', '" . $this->banktransfer_prz ."', '" . $this->banktransfer_bic ."', '" . $this->banktransfer_iban ."')");
      if ($_POST['banktransfer_fax'])
        xtc_db_query("update banktransfer set banktransfer_fax = '" . $this->banktransfer_fax ."' where orders_id = '" . $insert_id . "'");
        if ($this->order_status) xtc_db_query("UPDATE ". TABLE_ORDERS ." SET orders_status='".$this->order_status."' WHERE orders_id='".$insert_id."'");
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_ZONE', '0',  '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
	    xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_SORT_ORDER', '0', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_ORDER_STATUS_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_FAX_CONFIRMATION', 'false',  '6', '2', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_DATABASE_BLZ', 'false', '6', '0', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_URL_NOTE', 'fax.html', '6', '0', now())");
      xtc_db_query("CREATE TABLE IF NOT EXISTS banktransfer (orders_id int(11) NOT NULL default '0', banktransfer_owner varchar(64) default NULL, banktransfer_number varchar(24) default NULL, banktransfer_bankname varchar(255) default NULL, banktransfer_blz varchar(8) default NULL, banktransfer_status int(11) default NULL, banktransfer_prz char(2) default NULL, banktransfer_fax char(2) default NULL, banktransfer_bic varchar(11) default NULL, banktransfer_iban varchar(50) default NULL, KEY orders_id(orders_id))");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_BANKTRANSFER_MIN_ORDER', '0',  '6', '0', now())");
    }

// lang/german/modules/payment/banktransfer.php =======================================================================
define('MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_INFO', 'Bitte beachten Sie, dass das Lastschriftverfahren ohne Angabe von BIC/IBAN <b>nur</b> von einem <b>deutschen Girokonto</b> aus m&ouml;glich ist. <br />Durch Angabe von BIC/IBAN k&ouml;nnen Sie das Lastschriftverfahren <b>EU-weit</b> nutzen');

define('MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_IBAN', 'IBAN:');
define('MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_BIC', 'BIC:');

define('MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_11', 'Sie haben keinen BIC angegeben.');
define('MODULE_PAYMENT_BANKTRANSFER_TEXT_BANK_ERROR_12', 'Sie haben keine korrekte IBAN eingegeben.');

define('JS_BANK_BIC', '* Bitte geben Sie die BIC Ihrer Bank ein!\n\n');
define('JS_BANK_IBAN', '* Bitte geben Sie Ihre IBAN ein!\n\n');
?>