<?php
// Tabellarische Versandmodule besser pflegen
// goeko@goeko.de
?>
<script>
$(document).ready(function(){
    var shipping_fields = [],
        shipping_fields_arr = [
            'MODULE_SHIPPING_TABLE_COST_',
            'MODULE_SHIPPING_ZONES_COST_'
        ];

    getShipping = function(wrapper){
        var values = [],
            inputsWrapper = wrapper.find('.priceWrapper');

        inputsWrapper.each(function(i, e){
            var $inputs = $(e).find('input'),
                weight = $inputs.eq(0).val(),
                shipping_price = $inputs.eq(1).val();

            if(weight && shipping_price){
                values.push( parseFloat($inputs.eq(0).val()).toFixed(2) +':'+ parseFloat($inputs.eq(1).val()).toFixed(2) );
            }
        });
        return values.join(',');
    };

    setField = function(field){
        //console.log( typeof $this.val() === 'number' );

        if( field.val() != '') {
            field.val( parseFloat(field.val()).toFixed(2) );
        } else {
            field.val('');
        }
        if(field.val() == 'NaN'){
            field.val('');
        }
    };

    for(var s=0;s<shipping_fields_arr.length;s++){

        for(var n=0;n<11;n++){

            var shipping_field = $('[name*='+shipping_fields_arr[s]+n+']');

            if(shipping_field.length>0){
                var shipping_field_values = shipping_field.val(),
                    shipping_fieldWrapper = $('<div/>', {class:"shipping_fieldWrapper shipping_fieldWrapper"+s});

                shipping_field.wrapAll(shipping_fieldWrapper);

                var shipping_items = shipping_field_values.split(','),
                    shipping_values = [],
                    shipping_fieldWrapper = shipping_field.closest('div');

                if(shipping_items.length > 0){

                    var mode = $('[name*=MODULE_SHIPPING_TABLE_MODE]'),
                        mode_text = "Gewicht";
                    if(mode.length > 0){
                        var mode_id = $('[name*=MODULE_SHIPPING_TABLE_MODE]:checked').attr('id'),
                            mode_text = $('[for='+mode_id+']').text();
                    }

                    shipping_fieldWrapper.append('<div class="title"><div>max. '+mode_text+'</div><div>Versandkosten</div></div>')

                    for(var i=0; i<shipping_items.length; i++){
                        var shipping_item = shipping_items[i].split(':');
                        shipping_values.push(shipping_item);

                        var priceWrapper        = $('<div/>', {class:'priceWrapper'}),
                            cart_price          = $('<input/>', {value:shipping_item[0], type:"search", placeholder:'max. Bestellgewicht'}),
                            shipping_price      = $('<input/>', {value:shipping_item[1], type:"search", placeholder:'Versandkosten'});

                        priceWrapper.append(cart_price);
                        priceWrapper.append(shipping_price);

                        shipping_fieldWrapper.append(priceWrapper);

                    }
                    var priceWrapper        = $('<div/>', {class:'priceWrapper'}),
                        cart_price          = $('<input/>', {value:"", type:"search", placeholder:'max. Bestellgewicht'}),
                        shipping_price      = $('<input/>', {value:"", type:"search", placeholder:'Versandkosten'}),
                        buttonbar           = $('<div/>', {class:"buttonbar"}),
                        submit_btn           = $('<input/>', {value:"Speichern", type:"submit", class:"submit_btn"}),
                        reset_btn           = $('<input/>', {value:"Zurücksetzen", type:"reset", class:"reset_btn"});

                    priceWrapper.append(cart_price);
                    priceWrapper.append(shipping_price);

                    shipping_fieldWrapper.append(priceWrapper);

                    buttonbar.append(reset_btn);
                    buttonbar.append(submit_btn);
                    shipping_fieldWrapper.append(buttonbar);

                    var inputFields = shipping_fieldWrapper.find('input')
                        .not(".inputModule")
                        .not(".submit_btn")
                        .not(".reset_btn");
                    inputFields.each(function(i, e){
                        $input = $(e);
                        var wrapper = $input.closest('.shipping_fieldWrapper'),
                            shipping_field = wrapper.find('input').first();

                        $input.on('blur', function(){
                            $this = $(this);
                            setField($this, shipping_field, wrapper);
                            shipping_field.val( getShipping(wrapper) );
                        });
                        $input.on('search', function(){
                            $this = $(this);
                            $this.val('');
                            shipping_field.val( getShipping(wrapper) );
                        });

                    });
                }
            }



        }
    }

});
</script>